/*
 * DrawDocTurtle.java
 *
 * Created on February 21, 2003, 5:18 PM
 * 
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

package nom.DannyBrewer.OOoUno;

import nom.DannyBrewer.graphics.TurtleGraphicsImpl;
import nom.DannyBrewer.utils.ExceptionHandler;

// for test program main() at end.
import nom.DannyBrewer.graphics.TurtleGraphicsUtils;


//----------------------------------------------------------------------
//  UNO imports
//----------------------------------------------------------------------

// base of all interfaces
import com.sun.star.uno.XInterface;

// access the implementations via names
import com.sun.star.comp.servicemanager.ServiceManager;


import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;

import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import com.sun.star.uno.XComponentContext;


//----------------------------------------------------------------------
//  OpenOffice.org imports
//----------------------------------------------------------------------

// staroffice interfaces to provide desktop and componentloader
// and components i.e. spreadsheets, writerdocs etc.
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XComponentLoader;

// additional classes required
import com.sun.star.sheet.*;
import com.sun.star.container.*;
import com.sun.star.table.*;
import com.sun.star.beans.*;
import com.sun.star.style.*;
import com.sun.star.lang.*;
import com.sun.star.drawing.*;
import com.sun.star.text.XText;
import com.sun.star.awt.*;



/**
 * Instantiating this class creates a new Open Office Draw document.
 * Using the Turtle Graphics interface of this class draws lines
 *  in the Open Office Draw document.
 *
 * @author  danny brewer
 */
public class DrawDocTurtleGraphics extends TurtleGraphicsImpl
{	
	
    //----------------------------------------------------------------------
    //  Constructor
    //----------------------------------------------------------------------
	
	public DrawDocTurtleGraphics()
				throws	java.lang.Exception,
						com.sun.star.uno.Exception,
						com.sun.star.connection.NoConnectException,
						com.sun.star.beans.UnknownPropertyException
	{
		Object oOORmtServiceMgr = OOUtils.getOORemoteServiceManager();
		initialize( oOORmtServiceMgr );
	}
	
	public DrawDocTurtleGraphics( String host, String port )
				throws	java.lang.Exception,
						com.sun.star.uno.Exception,
						com.sun.star.connection.NoConnectException,
						com.sun.star.beans.UnknownPropertyException
	{
		Object oOORmtServiceMgr = OOUtils.getOORemoteServiceManager( host, port );
		initialize( oOORmtServiceMgr );
	}
	
	public DrawDocTurtleGraphics( String unoRemoteServiceManagerUrl )
				throws	java.lang.Exception,
						com.sun.star.uno.Exception,
						com.sun.star.connection.NoConnectException,
						com.sun.star.beans.UnknownPropertyException
	{
		Object oOORmtServiceMgr = OOUtils.getOORemoteServiceManager( unoRemoteServiceManagerUrl );
		initialize( oOORmtServiceMgr );
	}
	
	//----------------------------------------------------------------------
    //  Internal Support
    //----------------------------------------------------------------------
	
	// The drawing document.
	// Multiple interfaces to the same object.
	private XComponent				drawDoc_XComponent = null;
//	private XDrawPagesSupplier		drawDoc_XDrawPagesSupplier = null;
	private XMultiServiceFactory	drawDoc_XMultiServiceFactory = null;
	
	// The first page of the drawing.
	// The only page we work on.
	// Multiple interfaces to the same object.
	private XDrawPage				drawPage_XDrawPage = null;
//	private XShapes					drawPage_XShapes = null;
	
	
	private void initialize( Object oOORmtServiceMgr )
				throws com.sun.star.uno.Exception
	{
		// Create a new empty drawing document in the remote OpenOffice.org.
		drawDoc_XComponent = createDrawDocument( oOORmtServiceMgr );
		
		// Get some other useful interfaces to the same draw document object.
//		drawDoc_XDrawPagesSupplier = QueryInterface.XDrawPagesSupplier( drawDoc_XComponent );
		drawDoc_XMultiServiceFactory = QueryInterface.XMultiServiceFactory( drawDoc_XComponent );
		
		// Get page 0 of the draw document.
		drawPage_XDrawPage = OODrawUtils.getDrawPageByIndex( drawDoc_XComponent, 0 );
		
		// Get some other useful interfaces to the same draw document object.
//		drawPage_XShapes = QueryInterface.XShapes( drawPage_XDrawPage );
		
		// Get dimensions of the page.
		int pageHeight = OOUtils.getIntProperty( drawPage_XDrawPage, "Height" );
		int pageWidth  = OOUtils.getIntProperty( drawPage_XDrawPage, "Width" );
		
		// Initialize turtle to center of page, pen down.
		jumpTo( pageWidth / 2, pageHeight / 2 );
		penDown();
	}
	
	
	private XComponent createDrawDocument( Object oOORmtServiceMgr )
				throws com.sun.star.uno.Exception
	{
//		XMultiComponentFactory xMultiComponentFactory =
//				QueryInterface.XMultiComponentFactory( oOORmtServiceMgr );

		// Get the desired interface to the object.
		XMultiServiceFactory oOORmtServiceMgr_MultiServiceFactory =
				QueryInterface.XMultiServiceFactory( oOORmtServiceMgr );
		
		// Ask the MultiServiceFactory for a Desktop.
		// This might throw com.sun.star.uno.Exception.
		// This gives us the desktop, via. it's XInterface interface.
		XInterface desktop_XInterface =
				(XInterface) oOORmtServiceMgr_MultiServiceFactory.createInstance( "com.sun.star.frame.Desktop" );
		
		// Get the desired interface from the object.
		// We don't need the XInterface interface, we need the XComponentLoader interface to the object.
		XComponentLoader desktop_XComponentLoader =
				QueryInterface.XComponentLoader( desktop_XInterface );
		
		PropertyValue [] szEmptyArgs = new PropertyValue [0];
		String url = "private:factory/sdraw";
		// Ask the Desktop's component loader to load the url for a new Draw document.
		// This might throw com.sun.star.uno.Exception.
		// This gives us a drawing document.
		// It gives us the XComponent interface to the drawing.
		// There are other interfaces to this object available via. QueryInterface.
		XComponent drawDoc_XComponent = desktop_XComponentLoader.loadComponentFromURL( url, "_blank", 0, szEmptyArgs );
		
		return drawDoc_XComponent;
	}
	
		
    //----------------------------------------------------------------------
    //  Public API
    //----------------------------------------------------------------------
	
	
    //----------------------------------------------------------------------
    //  TurtleGraphics interface
	//	A simple implementation since we inherit from TurtleGraphicsImpl.
    //----------------------------------------------------------------------
	
	protected void drawLine( int xStart, int yStart, int xEnd, int yEnd ) {
		int width = xEnd - xStart;
		int height = yEnd - yStart;
		XShape lineShape = OODrawUtils.createLineShape( drawDoc_XMultiServiceFactory, xStart, yStart, width, height );
		drawPage_XDrawPage.add( lineShape );
	}

	
	//----------------------------------------------------------------------
    //  Internal Support
    //----------------------------------------------------------------------
	
	
	
	//----------------------------------------------------------------------
    //  Test Program
    //----------------------------------------------------------------------
	
    public static void main( String[] args ) {
		DrawDocTurtleGraphics turtle = null;
		try {
			turtle = new DrawDocTurtleGraphics();
        }
        catch ( java.lang.Exception e ) {
			e.printStackTrace();
			System.exit( 0 );
        }
		
//		turtle.move( 5000 );
		
		TurtleGraphicsUtils.drawPolygon( turtle, 5, 5000 );
		TurtleGraphicsUtils.inscribeStar( turtle, 5, 5000 );
		
		turtle.jumpBy( -8000, 4000 );
		
		TurtleGraphicsUtils.drawPolygon( turtle, 6, 3000 );
		TurtleGraphicsUtils.inscribeStar( turtle, 6, 3000 );
		
		turtle.jumpBy( 0, -6000 );
		
		TurtleGraphicsUtils.drawPolygon( turtle, 17, 800 );
		TurtleGraphicsUtils.inscribeStar( turtle, 17, 800, 6 );
		
		turtle.jumpBy( 4500, -2100 );
		
		TurtleGraphicsUtils.inscribeStar( turtle, 18, 800, 6 );
		
		System.exit( 0 );
    }
	
	
}
